﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Win32;
using Winfoot_7_SDK;

namespace WinfootDefaultSystemPlugin.Controls.Strategy
{
    public interface IHungAppTimeoutStrategy
    {
        void Write(int i);
        WFRegistry Read();
        List<WFRegistry> BackUp();
    }

    public class HungAppTimeoutDefaultStrategy : ICorrespondenceOS, IHungAppTimeoutStrategy
    {
        public HungAppTimeoutDefaultStrategy()
        {
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
#if DEBUG
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsSeven
#endif
                                       };
        }

        private string RegName = "ForceCopyAclwithFile";

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        #region IAdditionalWorkerThreadsStrategy メンバ

        public void Write(int i)
        {
            RegistryKey registryKey =
                Registry.CurrentUser.CreateSubKey(
                    @"Control Panel\Desktop");

            registryKey.SetValue(RegName, i);
        }

        public WFRegistry Read()
        {
            RegistryKey registryKey =
                Registry.CurrentUser.OpenSubKey(
                    @"Control Panel\Desktop");

            return new WFRegistry(@"HKEY_CURRENT_USER\Control Panel\Desktop", RegName,
                              registryKey.GetValue(RegName, 5000), RegistryValueKind.DWord, RegOperation.KeyWrite);



        }

        public List<WFRegistry> BackUp()
        {
            return new List<WFRegistry> { Read() };
        }

        #endregion
    }

    public class HungAppTimeoutController
    {
        public HungAppTimeoutController(HungAppTimeout hungAppTimeout,
                                                         IHungAppTimeoutStrategy strategy)
        {
            HungAppTimeout = hungAppTimeout;
            Strategy = strategy;
        }

        public HungAppTimeout HungAppTimeout { get; set; }
        public IHungAppTimeoutStrategy Strategy { get; set; }

        public void Read()
        {
            HungAppTimeout.SetHungAppTimeoutState(Convert.ToInt32(Strategy.Read().Value));
        }

        public void Write()
        {
            Strategy.Write(HungAppTimeout.GetHungAppTimeoutState());
        }

        public List<WFRegistry> BackUp()
        {
            return Strategy.BackUp();
        }
    }
}
